%% Affichage du niveau moyen des micros acquis par le systme d'acquisition
% mai 2021
% On suppose que les donnes ont t acquises correctement (en terme de
% nombre d'octets), en format int32, avec ventuellement le compteur A
% Dans les affichages, la numrotation commence  0
clear all
close all
%% VALEURS A ADAPTER
name = 'test1';
Sens_dB  = - 15.1;      % Sensibilit des micros (1 digit = -15.1dB)
aff_MAMIES = true;    % affichage par barre pour les micros de MAMIES
aff_juil19 = true;     % cas de l'exprience de juillet 2019 avec
                        % inversion des faisceaux 47 et 49
nb_aff = 768;           % nombre de micros affichs 
                        % (diffrent du nombre de micros acquis)
%% Lecture de l'en-tte
name_en_tete = strcat(name, ".Mu");
fid = fopen(name_en_tete,'rb');
header.annee = fread(fid,1,'uint16');
header.mois = fread(fid,1,'uint16');
header.jour_semaine = fread(fid,1,'uint16');
header.jour = fread(fid,1,'uint16');
header.heure = fread(fid,1,'uint16');
header.minute = fread(fid,1,'uint16');
header.seconde = fread(fid,1,'uint16');
header.ms = fread(fid,1,'uint16');
header.micros = fread(fid,1024,'uint8');
header.VA = fread(fid,16,'uint8');
header.compteurs = fread(fid,4,'uint8');
header.frequence = fread(fid,1,'single');
header.nb_ech = fread(fid,1,'uint32');
header.duree = fread(fid,1,'single');
header.type = fread(fid,1,'uint8');
header.commentaires = fread(fid,1024,'*char');
fclose(fid);
if (header.type ~= 0)
    disp('Les donnes ne sont pas en format Int32')
    return    
end
%%  Lecture donnes
nb_compteursBCD = sum(header.compteurs(2:4));
nb_VA = sum(header.VA);
nb_micros =  sum(header.micros);
nb_voies = nb_micros + nb_VA + header.compteurs(1);
if (nb_compteursBCD > 0)
    disp('Prsence de compteur(s) B, C, D. Enregistrement  refaire !');
    return
end
if (nb_micros == 0)
    disp('Pas de micro acquis. Enregistrement  refaire !');
    return
end
nb_ech = header.nb_ech;
name_dat = strcat(name,'.dat');
fid = fopen(name_dat,'rb');
mat=fread(fid,nb_ech*nb_voies,'*int32');
fclose(fid);
Fe = header.frequence;     % freq echant. en Hz
mat=reshape(mat,nb_voies,[]);
% Elimination du compteur A
if (header.compteurs(1) == 1)
    mat = mat(2:end,:);
    nb_voies = nb_voies - 1;
end
%% Dtermination du niveau moyen sur chaque voie acquise
y_rms = zeros(1,nb_voies);  
for num=1:nb_voies
    y = mat(num,:);
    y_rms(num) = 10 * log10(1+mean(y.^2)) + Sens_dB;
end
%% Elimination des voies analogiques
% Construction du tableau de micros
level = zeros(1,1024);
k = 0;
for i = 0:3
   for j = 1:256
       if(header.micros(j+256*i) == 1)
          k = k + 1;
          level(i * 256 + j) = y_rms(k);
       end
   end
   for j = 1:4
       if(header.VA(j+4*i) == 1)
          k = k + 1;
       end
   end
end
%% Affichage des niveaux
scrsz = get(0,'ScreenSize');    %dtermination de la taille de l'cran
fen_aff = [scrsz(3)/8 scrsz(4)/8 3*scrsz(3)/4 3*scrsz(4)/4];
figure('Position',fen_aff,'NumberTitle','off','Name','Niveau des micros','Color','White');
title(name)
plot(0:nb_aff-1,level(1:nb_aff));
set(gca,'FontName','Century Gothic','FontSize',14);
xlabel('Micro');
ylabel('Niveau (dB)');
%% Affichage bidim dans l'ordre des faisceaux
A = reshape(level,8,[]);
nb_fais = ceil(nb_aff/8);
figure('Position',fen_aff,'NumberTitle','off','Name','Niveau des micros','Color','White');
%imagesc([0 1023],[0 7],A, [0 100]);
imagesc([0 nb_fais-1],[0 7],A(:,1:nb_fais));
set(gca,'FontName','Century Gothic','FontSize',14);
xlabel('Faisceau');
ylabel('Micro');
axis xy;
c = colorbar;
c.Label.String = 'dB';
%% Affichage bidim adapt MAMIES 
% dans l'ordre des barres en partant d'en bas  gauche (orientation flux)
% d'o la renumrotation des barres
if (aff_MAMIES)
    A = reshape(level,16,[]);
    A(9:16,:) = A(16:-1:9,:); % rarrangement des micros des barres amont
    A(:,1:16) = A(:,16:-1:1); % numrotation des barres par face
    A(:,17:32) = A(:,32:-1:17);
    A(:,33:48) = A(:,48:-1:33);
    A(:,49:63) = A(:,63:-1:49);
    if (aff_juil19) % inversion des faisceaux 47 et 49
        C = A(9:16,23);
        A(9:16,23) = A(9:16,24);
        A(9:16,24) = C;
    end
    nb_bar = ceil(nb_aff/16);
    figure('Position',fen_aff, 'NumberTitle','off','Name','Niveau des micros','Color','White');
    imagesc([0 nb_bar-1],[0 15],A(:,1:nb_bar));
    set(gca,'FontName','Century Gothic','FontSize',14);
    xlabel('Barre');
    ylabel('Micro');
    axis xy;
    c = colorbar;
    c.Label.String = 'dB';
end
